package com.zehong.web.controller.patrol;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectWorkPointRecorde;
import com.zehong.system.service.ITInspectWorkPointRecordeService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检点记录信息Controller
 * 
 * @author zehong
 * @date 2022-06-21
 */
@RestController
@RequestMapping("/system/recorde")
public class TInspectWorkPointRecordeController extends BaseController
{
    @Autowired
    private ITInspectWorkPointRecordeService tInspectWorkPointRecordeService;

    /**
     * 查询巡检点记录信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        startPage();
        List<TInspectWorkPointRecorde> list = tInspectWorkPointRecordeService.selectTInspectWorkPointRecordeList(tInspectWorkPointRecorde);
        return getDataTable(list);
    }

    /**
     * 导出巡检点记录信息列表
     */
    @Log(title = "巡检点记录信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        List<TInspectWorkPointRecorde> list = tInspectWorkPointRecordeService.selectTInspectWorkPointRecordeList(tInspectWorkPointRecorde);
        ExcelUtil<TInspectWorkPointRecorde> util = new ExcelUtil<TInspectWorkPointRecorde>(TInspectWorkPointRecorde.class);
        return util.exportExcel(list, "巡检点记录信息数据");
    }

    /**
     * 获取巡检点记录信息详细信息
     */
    @GetMapping(value = "/{pointId}")
    public AjaxResult getInfo(@PathVariable("pointId") Long pointId)
    {
        return AjaxResult.success(tInspectWorkPointRecordeService.selectTInspectWorkPointRecordeById(pointId));
    }

    /**
     * 新增巡检点记录信息
     */
    @Log(title = "巡检点记录信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        return toAjax(tInspectWorkPointRecordeService.insertTInspectWorkPointRecorde(tInspectWorkPointRecorde));
    }

    /**
     * 修改巡检点记录信息
     */
    @Log(title = "巡检点记录信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectWorkPointRecorde tInspectWorkPointRecorde)
    {
        return toAjax(tInspectWorkPointRecordeService.updateTInspectWorkPointRecorde(tInspectWorkPointRecorde));
    }

    /**
     * 删除巡检点记录信息
     */
    @Log(title = "巡检点记录信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{pointIds}")
    public AjaxResult remove(@PathVariable Long[] pointIds)
    {
        return toAjax(tInspectWorkPointRecordeService.deleteTInspectWorkPointRecordeByIds(pointIds));
    }
}
