package com.zehong.web.controller.patrol;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInspectWorkInfo;
import com.zehong.system.service.ITInspectWorkInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.servlet.http.HttpServletRequest;

/**
 * 巡检任务信息Controller
 * 
 * @author zehong
 * @date 2022-06-20
 */
@RestController
@RequestMapping("/system/workinfo")
public class TInspectWorkInfoController extends BaseController
{
    @Autowired
    private ITInspectWorkInfoService tInspectWorkInfoService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询巡检任务信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(TInspectWorkInfo tInspectWorkInfo)
    {
        startPage();
        List<TInspectWorkInfo> list = tInspectWorkInfoService.selectTInspectWorkInfoList(tInspectWorkInfo);
        return getDataTable(list);
    }

    @GetMapping("/listTwo")
    public TableDataInfo listTwo(TInspectWorkInfo tInspectWorkInfo)
    {
        startPage();
        List<TInspectWorkInfo> list = tInspectWorkInfoService.selectTInspectWorkInfoListChildren(tInspectWorkInfo);
        return getDataTable(list);
    }

    /**
     * 个人巡检任务查询
     * @return
     */
    @GetMapping("/taskList")
    public TableDataInfo taskList(HttpServletRequest request)
    {
        LoginUser loginUser = tokenService.getLoginUser(request);
        Long deptId = loginUser.getUser().getDeptId();
        startPage();
        List<TInspectWorkInfo> list = tInspectWorkInfoService.taskList(deptId);
        return getDataTable(list);
    }
    /**
     * 导出巡检任务信息列表
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:export')")
    @Log(title = "巡检任务信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInspectWorkInfo tInspectWorkInfo)
    {
        List<TInspectWorkInfo> list = tInspectWorkInfoService.selectTInspectWorkInfoList(tInspectWorkInfo);
        ExcelUtil<TInspectWorkInfo> util = new ExcelUtil<TInspectWorkInfo>(TInspectWorkInfo.class);
        return util.exportExcel(list, "巡检任务信息数据");
    }

    /**
     * 获取巡检任务信息详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:query')")
    @GetMapping(value = "/{workId}")
    public AjaxResult getInfo(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tInspectWorkInfoService.selectTInspectWorkInfoById(workId));
    }

    /**
     * 新增巡检任务信息
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:add')")
    @Log(title = "巡检任务信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInspectWorkInfo tInspectWorkInfo)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        tInspectWorkInfo.setCreateBy(loginUser.getUsername());
        return toAjax(tInspectWorkInfoService.insertTInspectWorkInfo(tInspectWorkInfo));
    }

    /**
     * 修改巡检任务信息
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:edit')")
    @Log(title = "巡检任务信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInspectWorkInfo tInspectWorkInfo)
    {
        return toAjax(tInspectWorkInfoService.updateTInspectWorkInfo(tInspectWorkInfo));
    }

    /**
     * 删除巡检任务信息
     */
    //@PreAuthorize("@ss.hasPermi('system:workinfo:remove')")
    @Log(title = "巡检任务信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workIds}")
    public AjaxResult remove(@PathVariable Long[] workIds)
    {
        return toAjax(tInspectWorkInfoService.deleteTInspectWorkInfoByIds(workIds));
    }
}
