package com.zehong.web.controller.hiddenDanger;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenTroubleAssessment;
import com.zehong.system.service.ITHiddenTroubleAssessmentService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 排查评估Controller
 * 
 * @author zehong
 * @date 2022-07-12
 */
@RestController
@RequestMapping("/system/assessment")
public class THiddenTroubleAssessmentController extends BaseController
{
    @Autowired
    private ITHiddenTroubleAssessmentService tHiddenTroubleAssessmentService;

    /**
     * 查询排查评估列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:list')")
    @GetMapping("/list")
    public TableDataInfo list(THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        startPage();
        List<THiddenTroubleAssessment> list = tHiddenTroubleAssessmentService.selectTHiddenTroubleAssessmentList(tHiddenTroubleAssessment);
        return getDataTable(list);
    }

    /**
     * 导出排查评估列表
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:export')")
    @Log(title = "排查评估", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        List<THiddenTroubleAssessment> list = tHiddenTroubleAssessmentService.selectTHiddenTroubleAssessmentList(tHiddenTroubleAssessment);
        ExcelUtil<THiddenTroubleAssessment> util = new ExcelUtil<THiddenTroubleAssessment>(THiddenTroubleAssessment.class);
        return util.exportExcel(list, "排查评估数据");
    }

    /**
     * 获取排查评估详细信息
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:query')")
    @GetMapping(value = "/{assessmentId}")
    public AjaxResult getInfo(@PathVariable("assessmentId") Long assessmentId)
    {
        return AjaxResult.success(tHiddenTroubleAssessmentService.selectTHiddenTroubleAssessmentById(assessmentId));
    }
    @GetMapping(value = "/workId/{workId}")
    public AjaxResult getAssessmentWorkId(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tHiddenTroubleAssessmentService.selectTHiddenTroubleAssessmentByWorkId(workId));
    }

    /**
     * 新增排查评估
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:add')")
    @Log(title = "排查评估", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        return toAjax(tHiddenTroubleAssessmentService.insertTHiddenTroubleAssessment(tHiddenTroubleAssessment));
    }

    /**
     * 修改排查评估
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:edit')")
    @Log(title = "排查评估", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenTroubleAssessment tHiddenTroubleAssessment)
    {
        return toAjax(tHiddenTroubleAssessmentService.updateTHiddenTroubleAssessment(tHiddenTroubleAssessment));
    }

    /**
     * 删除排查评估
     */
    ////@PreAuthorize("@ss.hasPermi('system:assessment:remove')")
    @Log(title = "排查评估", businessType = BusinessType.DELETE)
	@DeleteMapping("/{assessmentIds}")
    public AjaxResult remove(@PathVariable Long[] assessmentIds)
    {
        return toAjax(tHiddenTroubleAssessmentService.deleteTHiddenTroubleAssessmentByIds(assessmentIds));
    }
}
