package com.zehong.web.controller.emergency;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyCrew;
import com.zehong.system.service.ITEmergencyCrewService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急通讯人员管理Controller
 *
 * @author zehong
 * @date 2022-06-29
 */
@RestController
@RequestMapping("/emergency/crew")
public class TEmergencyCrewController extends BaseController
{
    @Autowired
    private ITEmergencyCrewService tEmergencyCrewService;

    /**
     * 查询应急通讯人员管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyCrew tEmergencyCrew)
    {
        startPage();
        List<TEmergencyCrew> list = tEmergencyCrewService.selectTEmergencyCrewList(tEmergencyCrew);
        return getDataTable(list);
    }

    /**
     * 导出应急通讯人员管理列表
     */
    @Log(title = "应急通讯人员管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyCrew tEmergencyCrew)
    {
        List<TEmergencyCrew> list = tEmergencyCrewService.selectTEmergencyCrewList(tEmergencyCrew);
        ExcelUtil<TEmergencyCrew> util = new ExcelUtil<TEmergencyCrew>(TEmergencyCrew.class);
        return util.exportExcel(list, "应急通讯人员管理数据");
    }

    /**
     * 获取应急通讯人员管理详细信息
     */
    @GetMapping(value = "/{communicationId}")
    public AjaxResult getInfo(@PathVariable("communicationId") Long communicationId)
    {
        return AjaxResult.success(tEmergencyCrewService.selectTEmergencyCrewById(communicationId));
    }

    /**
     * 新增应急通讯人员管理
     */
    @Log(title = "应急通讯人员管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyCrew tEmergencyCrew)
    {
        return toAjax(tEmergencyCrewService.insertTEmergencyCrew(tEmergencyCrew));
    }

    /**
     * 修改应急通讯人员管理
     */
    @Log(title = "应急通讯人员管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyCrew tEmergencyCrew)
    {
        return toAjax(tEmergencyCrewService.updateTEmergencyCrew(tEmergencyCrew));
    }

    /**
     * 删除应急通讯人员管理
     */
    @Log(title = "应急通讯人员管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{communicationIds}")
    public AjaxResult remove(@PathVariable Long[] communicationIds)
    {
        return toAjax(tEmergencyCrewService.deleteTEmergencyCrewByIds(communicationIds));
    }
}
