package com.zehong.web.controller.deviceManagement;

import java.util.List;

import com.zehong.system.domain.vo.TRepairOrderVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TRepairOrder;
import com.zehong.system.service.ITRepairOrderService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备维修工单Controller
 * 
 * @author zehong
 * @date 2022-07-04
 */
@RestController
@RequestMapping("/deviceManagement/repairOrder")
public class TRepairOrderController extends BaseController
{
    @Autowired
    private ITRepairOrderService tRepairOrderService;

    /**
     * 查询设备维修工单列表
     */
    //@PreAuthorize("@ss.hasPermi('deviceManagement:repairOrder:list')")
    @GetMapping("/list")
    public TableDataInfo list(TRepairOrder tRepairOrder)
    {
        startPage();
        List<TRepairOrderVo> list = tRepairOrderService.selectTRepairOrderList(tRepairOrder);
        return getDataTable(list);
    }

    /**
     * 导出设备维修工单列表
     */
    @Log(title = "设备维修工单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TRepairOrder tRepairOrder)
    {
        List<TRepairOrderVo> list = tRepairOrderService.selectTRepairOrderList(tRepairOrder);
        ExcelUtil<TRepairOrderVo> util = new ExcelUtil<TRepairOrderVo>(TRepairOrderVo.class);
        return util.exportExcel(list, "设备维修工单数据");
    }

    /**
     * 获取设备维修工单详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tRepairOrderService.selectTRepairOrderById(id));
    }

    /**
     * 新增设备维修工单
     */
    @Log(title = "设备维修工单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TRepairOrder tRepairOrder)
    {
        return toAjax(tRepairOrderService.insertTRepairOrder(tRepairOrder));
    }

    /**
     * 修改设备维修工单
     */
    @Log(title = "设备维修工单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TRepairOrder tRepairOrder)
    {
        return toAjax(tRepairOrderService.updateTRepairOrder(tRepairOrder));
    }

    /**
     * 删除设备维修工单
     */
    @Log(title = "设备维修工单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tRepairOrderService.deleteTRepairOrderByIds(ids));
    }
}
