package com.zehong.web.controller.deviceManagement;

import java.util.List;

import com.zehong.system.domain.vo.TMaintainPlanVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMaintainPlan;
import com.zehong.system.service.ITMaintainPlanService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备保养计划Controller
 * 
 * @author zehong
 * @date 2022-07-04
 */
@RestController
@RequestMapping("/deviceManagement/maintainPlan")
public class TMaintainPlanController extends BaseController
{
    @Autowired
    private ITMaintainPlanService tMaintainPlanService;

    /**
     * 查询设备保养计划列表
     */
    //@PreAuthorize("@ss.hasPermi('deviceManagement:maintainPlan:list')")
    @GetMapping("/list")
    public TableDataInfo list(TMaintainPlan tMaintainPlan)
    {
        startPage();
        List<TMaintainPlanVo> list = tMaintainPlanService.selectTMaintainPlanList(tMaintainPlan);
        return getDataTable(list);
    }

    /**
     * 导出设备保养计划列表
     */
    @Log(title = "设备保养计划", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMaintainPlan tMaintainPlan)
    {
        List<TMaintainPlanVo> list = tMaintainPlanService.selectTMaintainPlanList(tMaintainPlan);
        ExcelUtil<TMaintainPlanVo> util = new ExcelUtil<TMaintainPlanVo>(TMaintainPlanVo.class);
        return util.exportExcel(list, "设备保养计划数据");
    }

    /**
     * 获取设备保养计划详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tMaintainPlanService.selectTMaintainPlanById(id));
    }

    /**
     * 新增设备保养计划
     */
    @Log(title = "设备保养计划", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMaintainPlan tMaintainPlan)
    {
        return toAjax(tMaintainPlanService.insertTMaintainPlan(tMaintainPlan));
    }

    /**
     * 修改设备保养计划
     */
    @Log(title = "设备保养计划", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMaintainPlan tMaintainPlan)
    {
        return toAjax(tMaintainPlanService.updateTMaintainPlan(tMaintainPlan));
    }

    /**
     * 删除设备保养计划
     */
    @Log(title = "设备保养计划", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tMaintainPlanService.deleteTMaintainPlanByIds(ids));
    }
}
