package com.zehong.web.controller.deviceManagement;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 设备信息管理Controller
 * 
 * @author zehong
 * @date 2022-07-02
 */
@RestController
@RequestMapping("/deviceManagement/deviceInfo")
public class TDeviceInfoController extends BaseController
{
    @Autowired
    private ITDeviceInfoService tDeviceInfoService;

    @Autowired
    private TokenService tokenService;

    /**
     * 查询设备信息管理列表
     */
    //@PreAuthorize("@ss.hasPermi('deviceManagement:deviceInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceInfo tDeviceInfo)
    {
        startPage();
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return getDataTable(list);
    }

    /**
     * 查询特种设备列表
     */
    @GetMapping("/listSpecial")
    public AjaxResult listSpecial(TDeviceInfo tDeviceInfo)
    {
        tDeviceInfo.setIsSpecial("1");
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出设备信息管理列表
     */
    @Log(title = "设备信息管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceInfo tDeviceInfo)
    {
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        return util.exportExcel(list, "设备信息管理数据");
    }

    /**
     * 导入设备信息管理列表
     */
    @Log(title = "设备信息管理", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importDevice(MultipartFile file, boolean updateSupport) throws Exception
    {

        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        List<TDeviceInfo> userList = util.importExcel(file.getInputStream());
        String message = tDeviceInfoService.importDevice(userList, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate()
    {
        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        return util.importTemplateExcel("设备数据");
    }

    /**
     * 获取设备信息管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDeviceInfoService.selectTDeviceInfoById(id));
    }

    /**
     * 新增设备信息管理
     */
    @Log(title = "设备信息管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDeviceInfo tDeviceInfo)
    {
        return toAjax(tDeviceInfoService.insertTDeviceInfo(tDeviceInfo));
    }

    /**
     * 修改设备信息管理
     */
    @Log(title = "设备信息管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceInfo tDeviceInfo)
    {
        return toAjax(tDeviceInfoService.updateTDeviceInfo(tDeviceInfo));
    }

    /**
     * 删除设备信息管理
     */
    @Log(title = "设备信息管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDeviceInfoService.deleteTDeviceInfoByIds(ids));
    }
}
