package com.zehong.web.controller.contractor;

import java.util.List;

import com.zehong.system.domain.vo.TContractorPersonVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractorPerson;
import com.zehong.system.service.ITContractorPersonService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商人员信息Controller
 * 
 * @author zehong
 * @date 2022-06-29
 */
@RestController
@RequestMapping("/contractor/contractorPerson")
public class TContractorPersonController extends BaseController
{
    @Autowired
    private ITContractorPersonService tContractorPersonService;

    /**
     * 查询承包商人员信息列表
     */
    //@PreAuthorize("@ss.hasPermi('contractor:contractorPerson:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractorPerson tContractorPerson)
    {
        startPage();
        List<TContractorPersonVo> list = tContractorPersonService.selectTContractorPersonList(tContractorPerson);
        return getDataTable(list);
    }

    /**
     * 导出承包商人员信息列表
     */
    @Log(title = "承包商人员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractorPerson tContractorPerson)
    {
        List<TContractorPersonVo> list = tContractorPersonService.selectTContractorPersonList(tContractorPerson);
        ExcelUtil<TContractorPersonVo> util = new ExcelUtil<TContractorPersonVo>(TContractorPersonVo.class);
        return util.exportExcel(list, "承包商人员信息数据");
    }

    /**
     * 获取承包商人员信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tContractorPersonService.selectTContractorPersonById(id));
    }

    /**
     * 新增承包商人员信息
     */
    @Log(title = "承包商人员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractorPerson tContractorPerson)
    {
        return toAjax(tContractorPersonService.insertTContractorPerson(tContractorPerson));
    }

    /**
     * 修改承包商人员信息
     */
    @Log(title = "承包商人员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractorPerson tContractorPerson)
    {
        return toAjax(tContractorPersonService.updateTContractorPerson(tContractorPerson));
    }

    /**
     * 删除承包商人员信息
     */
    @Log(title = "承包商人员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tContractorPersonService.deleteTContractorPersonByIds(ids));
    }
}
