package com.zehong.web.controller.contractor;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TContractor;
import com.zehong.system.service.ITContractorService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 承包商信息Controller
 * 
 * @author zehong
 * @date 2022-06-29
 */
@RestController
@RequestMapping("/contractor/contractorInfo")
public class TContractorController extends BaseController
{
    @Autowired
    private ITContractorService tContractorService;

    /**
     * 查询承包商信息列表
     */
    //@PreAuthorize("@ss.hasPermi('contractor:contractorInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(TContractor tContractor)
    {
        startPage();
        List<TContractor> list = tContractorService.selectTContractorList(tContractor);
        return getDataTable(list);
    }

    /**
     * 查询承包商信息树
     */
    @GetMapping("/listAll")
    public AjaxResult listAll(TContractor tContractor)
    {
        List<TContractor> list = tContractorService.selectTContractorList(tContractor);
        return AjaxResult.success(list);
    }

    /**
     * 导出承包商信息列表
     */
    @Log(title = "承包商信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TContractor tContractor)
    {
        List<TContractor> list = tContractorService.selectTContractorList(tContractor);
        ExcelUtil<TContractor> util = new ExcelUtil<TContractor>(TContractor.class);
        return util.exportExcel(list, "承包商信息数据");
    }

    /**
     * 获取承包商信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tContractorService.selectTContractorById(id));
    }

    /**
     * 新增承包商信息
     */
    @Log(title = "承包商信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TContractor tContractor)
    {
        return toAjax(tContractorService.insertTContractor(tContractor));
    }

    /**
     * 修改承包商信息
     */
    @Log(title = "承包商信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TContractor tContractor)
    {
        return toAjax(tContractorService.updateTContractor(tContractor));
    }

    /**
     * 删除承包商信息
     */
    @Log(title = "承包商信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tContractorService.deleteTContractorByIds(ids));
    }
}
