package com.zehong.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.zehong.constant.ProduceCodeRules;
import com.zehong.service.ProduceScanCodeResultService;
import com.zehong.utils.RedisCache;
import com.zehong.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 产品扫码结果
 */
@Service
@DS("mes")
public class ProduceScanCodeResultServiceImpl implements ProduceScanCodeResultService{

    private static final Logger log = LoggerFactory.getLogger(ProduceScanCodeResultServiceImpl.class);

    @Autowired
    private RedisCache redisCache;


    /**
     * 产品扫码规则
     */
    private final Map<String,Pattern> produceRules = new HashMap<>();

    {
        for(ProduceCodeRules rule: ProduceCodeRules.values()){
            produceRules.put(rule.name(),Pattern.compile(rule.getRegex()));
        }
    }


    /**
     * 产品扫码结果
     * @param message 扫码信息
     * @return int
     */
    @Override
    public int produceScanCodeResult(String message){
        log.info("扫码结果字符串=========" + message);
        Map<String,Object> result = analysisProduceMessage(message);
        return addProduceDevice(result);
    }

    /**
     * 解析产品信息
     * @param message 扫码信息
     * @return Map<String,Object>
     */
    private Map<String,Object> analysisProduceMessage(String message){
        Map<String,Object> result = new HashMap<>();
        for(Map.Entry<String, Pattern> rule : produceRules.entrySet()){
            List<String> codes = new ArrayList<>();
            Matcher m = rule.getValue().matcher(message);
            while (m.find()){
                String code = m.group();
                codes.add(code);
                message = message.replace(code,"");
            }
            if(!CollectionUtils.isEmpty(codes)) result.put(rule.getKey(),codes);
        }
        //扫描设备码
        if(StringUtils.isNotEmpty(message)) result.put("deviceCode",message);
        return result;
    }

    /**
     * 新增产品设备
     * @param result 解析结果
     * @return int
     */
    private int addProduceDevice(Map<String,Object> result){

        return 0;
    }

}
