package com.zehong.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.zehong.dao.PCBADevicesMapper;
import com.zehong.entity.PCBADevices;
import com.zehong.service.AoiTestResultService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import javax.annotation.Resource;
import java.util.List;


/**
 * AOI检查结果
 * @author geng
 */
@Service
@DS("mes")
public class AoiTestResultServiceImpl implements AoiTestResultService{

    private static final Logger log = LoggerFactory.getLogger(AoiTestResultServiceImpl.class);

    @Resource
    private PCBADevicesMapper pcbaDevicesMapper;

    /**
     * AOI检查结果同步
     * @param result
     */
    public int syncAoiResult(String result){
        int insertResult = 0;
        JSONObject resultJson = JSON.parseObject(result);
        log.info("aoi检测结果=====" + resultJson);
        JSONArray boardData = resultJson.getJSONArray("board_data");
        if(null != boardData){
            for(Object obj : boardData){
                JSONObject boardInfo = (JSONObject)obj;
                String motherboardCode = boardInfo.getString("board_sn");
                List<PCBADevices> devices = pcbaDevicesMapper.selectPcbaDeviceInfoByBoardCode(motherboardCode);
                if(!CollectionUtils.isEmpty(devices)){
                    for(PCBADevices device : devices){
                        String finalResult = boardInfo.getString("board_final_result");
                        device.setAoiDetectionResult(finalResult);
                        insertResult += pcbaDevicesMapper.updatePcbaDeviceInfo(device);
                    }
                }
            }
        }
        return insertResult;
    }
}
