package com.zehong.generator;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MyBatisPlusGenerator {
    public static void main(String[] args) {
        // 代码生成器
        AutoGenerator generator = new AutoGenerator();

        // 全局配置
        GlobalConfig globalConfig = new GlobalConfig();
        String projectPath = System.getProperty("user.dir");
        globalConfig.setOutputDir(projectPath + "/src/main/java");
        globalConfig.setAuthor("geng");
        globalConfig.setOpen(false); // 生成后不打开文件夹
        globalConfig.setFileOverride(true); // 覆盖已生成文件
        globalConfig.setBaseResultMap(true); // 生成ResultMap
        globalConfig.setBaseColumnList(true); // 生成columnList
        globalConfig.setServiceName("%sService"); // 自定义Service接口名
        generator.setGlobalConfig(globalConfig);

        // 数据源配置
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setDbType(DbType.MYSQL);
        dataSourceConfig.setUrl("jdbc:mysql://36.138.180.82:3309/zh-mes-device-db?useSSL=false&serverTimezone=GMT%2B8");
        dataSourceConfig.setDriverName("com.mysql.jdbc.Driver");
        dataSourceConfig.setUsername("zh-mes-device-db");
        dataSourceConfig.setPassword("KJThfp2x85YMmGAw");
        generator.setDataSource(dataSourceConfig);

        // 包配置
        PackageConfig packageConfig = new PackageConfig();
        packageConfig.setParent("com.zehong");
        packageConfig.setEntity("entity");
        packageConfig.setMapper("dao");
        packageConfig.setService("service");
        packageConfig.setController("controller");
        generator.setPackageInfo(packageConfig);

        // 自定义配置（重点：XML文件生成位置）
        InjectionConfig cfg = new InjectionConfig() {
            @Override
            public void initMap() {
                Map<String, Object> map = new HashMap<>();
                map.put("abc", this.getConfig().getGlobalConfig().getAuthor());
                this.setMap(map);
            }
        };

        // 自定义输出配置
        List<FileOutConfig> focList = new ArrayList<>();
        // 自定义XML文件生成位置
        focList.add(new FileOutConfig("/templates/mapper.xml.vm") {
            @Override
            public String outputFile(TableInfo tableInfo) {
                // 指定XML文件生成在resources/mapper目录下
                return projectPath + "/src/main/resources/mapper/" + tableInfo.getMapperName() + ".xml";
            }
        });

        cfg.setFileOutConfigList(focList);
        generator.setCfg(cfg);

        // 配置模板
        generator.setTemplate(new TemplateConfig().setXml(null)); // 关闭默认XML生成

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel); // 表名转驼峰
        strategy.setColumnNaming(NamingStrategy.underline_to_camel); // 列名转驼峰
        strategy.setEntityLombokModel(true); // 使用Lombok
        strategy.setRestControllerStyle(true); // REST风格控制器
        strategy.setInclude("t_pcb_board_engrave_data"); // 需要生成的表
        strategy.setTablePrefix("t_"); // 表前缀过滤
        strategy.setControllerMappingHyphenStyle(true); // URL中驼峰转连字符
        generator.setStrategy(strategy);

        // 模板配置
       // generator.setTemplateEngine(new VelocityTemplateEngine());

        // 执行生成
        generator.execute();
    }
}
