package com.zehong.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * pcb板镭雕机数据
 * </p>
 *
 * @author geng
 * @since 2025-05-21
 */
@EqualsAndHashCode(callSuper = false)
@TableName("t_pcb_board_engrave_data")
public class PcbBoardEngraveData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(value = "f_pcb_board_engrave_id", type = IdType.AUTO)
    private Long fPcbBoardEngraveId;

    /**
     * pcb板数据
     */
    @NotBlank
    private String fContent;

    /**
     * 打印时间
     */
    @NotBlank
    private String fPrintTime;

    /**
     * 创建时间
     */
    private Date createTime;


    public Long getfPcbBoardEngraveId() {
        return fPcbBoardEngraveId;
    }

    public void setfPcbBoardEngraveId(Long fPcbBoardEngraveId) {
        this.fPcbBoardEngraveId = fPcbBoardEngraveId;
    }

    public String getfContent() {
        return fContent;
    }

    public void setfContent(String fContent) {
        this.fContent = fContent;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getfPrintTime() {
        return fPrintTime;
    }

    public void setfPrintTime(String fPrintTime) {
        this.fPrintTime = fPrintTime;
    }
}
