package com.zehong.constant;

/**
 * pcba扫码规则
 */
public enum  PCBACodeRules {

    /**
     * 卡批次码
     */
    CARDBATCHCODE("(SL|SD|SY|QL|QD|QY)\\d{9}"),

    /**
     * 主板码
     */
    MAINBOARDCODE("PCBA\\d{14}"),

    /**
     * 传感器批次码
     */
    SENSORBATCHCODE("SEN\\d{9}");

    private String regex;

    PCBACodeRules(String regex) {
        this.regex = regex;
    }

    public String getRegex() {
        return regex;
    }
}
