package com.zehong.controller;

import com.zehong.entity.AjaxResult;
import com.zehong.service.ProduceScanCodeResultService;
import com.zehong.service.ScanCodeResultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码结果
 * @author geng
 * @since 2025-05-27
 */
@RestController
@RequestMapping("/scan")
public class ScanCodeResultController extends BaseController{

    /**
     * pcba扫码接口
     */
    @Autowired
    private ScanCodeResultService scanCodeResultService;

    /**
     * 产品扫码接口
     */
    @Autowired
    private ProduceScanCodeResultService produceScanCodeResultService;

    /**
     * pcba 扫码结果
     * @param message 扫码信息
     * @return
     */
    @PostMapping("/scanCode")
    public AjaxResult scanCode(@RequestBody String message) {
        return toAjax(scanCodeResultService.scanCodeResult(message));
    }


    /**
     * 产品扫码结果
     * @param message 扫码信息
     * @return
     */
    @PostMapping("/produceScanCode")
    public AjaxResult produceScanCode(@RequestBody String message) {
        return toAjax(produceScanCodeResultService.produceScanCodeResult(message));
    }

}
