package com.zehong.dao;

import com.zehong.entity.PCBADevices;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface PCBADevicesMapper {

    /**
     * 根据主板号查询设备信息
     * @param motherboardCode 主板吗
     * @return
     */
    List<PCBADevices> selectPcbaDeviceInfoByBoardCode(String motherboardCode);

    List<PCBADevices> selectPcbaDeviceInfoByBoardCodeAndPlateType(@Param("motherboardCode") String motherboardCode,
                                                                     @Param("plateType") String plateType);

    List<PCBADevices> selectPcbaDeviceInfoByNbBoradCodeAndTasksNumber(@Param("nbMotherBoardCode") String nbMotherBoardCode,
                                                                      @Param("pcbaProductionTasksNumber") String pcbaProductionTasksNumber);

    /**
     * 更新设备信息
     * @param devices 设备信息
     * @return
     */
    int updatePcbaDeviceInfo(PCBADevices devices);

    /**
     * 新增设备信息
     * @param devices 设备信息
     * @return
     */
    int insertPcbaDevices(PCBADevices devices);

    /**
     * 根据主板码更新设备信息
     * @param devices
     * @return
     */
    int updatePcbaDeviceInfoByMotherBoardCode(PCBADevices devices);
}
