package com.zehong.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.zehong.dao.PCBADevicesMapper;
import com.zehong.entity.PCBADevices;
import com.zehong.service.AoiTestResultService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * AOI检查结果
 * @author geng
 */
@Service
@DS("mes")
public class AoiTestResultServiceImpl implements AoiTestResultService{

    private static final Logger log = LoggerFactory.getLogger(AoiTestResultServiceImpl.class);

    @Resource
    private PCBADevicesMapper pcbaDevicesMapper;

    /**
     * AOI检查结果同步
     * @param result
     */
    public Map<String,Object> syncAoiResult(String result){
        int insertResult = 0;
        Map<String,Object> map = new HashMap<>();
        JSONObject resultJson = JSON.parseObject(result);
        log.info("aoi检测结果=====" + resultJson);
        JSONArray boardData = resultJson.getJSONArray("board_data");
        if(null != boardData){
            for(Object obj : boardData){
                JSONObject boardInfo = (JSONObject)obj;
                String motherboardCode = boardInfo.getString("board_sn");
                List<PCBADevices> devices = pcbaDevicesMapper.selectPcbaDeviceInfoByBoardCode(motherboardCode);
                if(!CollectionUtils.isEmpty(devices)){
                    for(PCBADevices device : devices){
                        String finalResult = boardInfo.getString("board_final_result");
                        device.setAoiDetectionResult(finalResult);
                        insertResult += pcbaDevicesMapper.updatePcbaDeviceInfo(device);
                    }
                }
            }
        }

        if(insertResult != 0) {
            map.put("code",200);
            map.put("message","上传成功");
            return map;
        }

        map.put("code",400);
        map.put("message","上传失败");
        return map;
    }
}
