package com.zehong.dao;

import com.zehong.entity.ProductDeviceList;

import java.util.List;

/**
 * 产品设备列Mapper接口
 * 
 * @author zehong
 * @date 2025-06-10
 */
public interface ProductDeviceListMapper 
{
    /**
     * 查询产品设备列
     * 
     * @param productDeviceListId 产品设备列ID
     * @return 产品设备列
     */
    public ProductDeviceList selectProductDeviceListById(Long productDeviceListId);

    /**
     * 查询产品设备列列表
     * 
     * @param productDeviceList 产品设备列
     * @return 产品设备列集合
     */
    public List<ProductDeviceList> selectProductDeviceListList(ProductDeviceList productDeviceList);

    /**
     * 新增产品设备列
     * 
     * @param productDeviceList 产品设备列
     * @return 结果
     */
    public int insertProductDeviceList(ProductDeviceList productDeviceList);

    /**
     * 修改产品设备列
     * 
     * @param productDeviceList 产品设备列
     * @return 结果
     */
    public int updateProductDeviceList(ProductDeviceList productDeviceList);

    /**
     * 删除产品设备列
     * 
     * @param productDeviceListId 产品设备列ID
     * @return 结果
     */
    public int deleteProductDeviceListById(Long productDeviceListId);

    /**
     * 批量删除产品设备列
     * 
     * @param productDeviceListIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProductDeviceListByIds(Long[] productDeviceListIds);
}
