package com.zehong.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zehong.entity.AjaxResult;
import com.zehong.entity.PcbBoardEngraveData;
import com.zehong.service.PcbBoardEngraveDataService;
import com.zehong.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * pcb板镭雕机数据 前端控制器
 * </p>
 *
 * @author geng
 * @since 2025-05-21
 */
@RestController
@RequestMapping("/pcbBoardEngraveData")
public class PcbBoardEngraveDataController extends BaseController{

    @Autowired
    private PcbBoardEngraveDataService pcbBoardEngraveDataService;


    /**
     * 板镭雕机数据查询
     * @return
     */
    @GetMapping("/pcbBoardEngraveDataList")
    public AjaxResult pcbBoardEngraveDataList() {
        return AjaxResult.success(pcbBoardEngraveDataService.list());
    }


    /**
     * 板镭雕机数据分页查询
     * @return
     */
    @GetMapping("/pcbBoardEngraveDataListByPage")
    public AjaxResult pcbBoardEngraveDataListByPage(int current, int size, PcbBoardEngraveData data) {
        Page<PcbBoardEngraveData> page = new Page<>(current,size);
        pcbBoardEngraveDataService.page(page,new QueryWrapper<>(data));
        return AjaxResult.success(page);
    }

    /**
     * 板镭雕机数据保存
     * @param data d
     * @return r
     */
    @PostMapping("savePcbBoardEngraveData")
    public AjaxResult savePcbBoardEngraveDataList(@RequestBody List<PcbBoardEngraveData> data){

        if(data == null || data.size() ==  0) {
            return AjaxResult.error("数据不能为空");
        }

        for (PcbBoardEngraveData datum : data) {
            if(StringUtils.isBlank(datum.getfPrintTime()) || StringUtils.isBlank(datum.getfContent())) {
                return AjaxResult.error("数据不能为空");
            }
        }

        data.forEach(item -> item.setCreateTime(new Date()));
        return toAjax(pcbBoardEngraveDataService.saveBatch(data));
    }
}

