package com.zehong.system.domain.shelf;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 料架信息对象 t_shelf_info
 * 
 * @author zehong
 * @date 2025-09-20
 */
public class TShelfInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 料架记录唯一ID */
    private Long fShelfId;

    /** 料架类型：0-pcba，1-仓库 */
    @Excel(name = "料架类型",readConverterExp = "0=pcba,1=仓库")
    private Integer fType;

    /** 料架编号 */
    @Excel(name = "料架编号")
    private String fShelf;

    /** 状态 */
    @Excel(name = "状态",readConverterExp = "0=离线,1=就绪")
    private Integer fStatus;

    public void setfShelfId(Long fShelfId) 
    {
        this.fShelfId = fShelfId;
    }

    public Long getfShelfId() 
    {
        return fShelfId;
    }
    public void setfType(Integer fType) 
    {
        this.fType = fType;
    }

    public Integer getfType() 
    {
        return fType;
    }
    public void setfShelf(String fShelf) 
    {
        this.fShelf = fShelf;
    }

    public String getfShelf() 
    {
        return fShelf;
    }
    public void setfStatus(Integer fStatus) 
    {
        this.fStatus = fStatus;
    }

    public Integer getfStatus() 
    {
        return fStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fShelfId", getfShelfId())
            .append("fType", getfType())
            .append("fShelf", getfShelf())
            .append("fStatus", getfStatus())
            .toString();
    }
}
