package com.zehong.system.service.impl.shelf.aspectj;

import com.alibaba.fastjson.JSONObject;
import com.zehong.system.service.impl.shelf.NotificationWebSocket;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * 料架第三方反馈通知前台切面
 */
@Aspect
@Component
public class NotificationAspect {

    // 定义切点：拦截带有@SendNotification注解的方法
    @Pointcut("@annotation(com.zehong.system.service.impl.shelf.annotation.SendNotification)")
    public void notificationPointcut() {}

    // 后置通知：在方法执行后发送通知
    @AfterReturning(pointcut = "notificationPointcut()")
    public void sendAfterNotification(JoinPoint joinPoint) {
        JSONObject param = (JSONObject) joinPoint.getArgs()[0];
        NotificationWebSocket.broadcast(param.toJSONString());
    }
}