import request from '@/utils/request'

// 查询料架信息列表
export function listInfo(query) {
  return request({
    url: '/shelf/info/list',
    method: 'get',
    params: query
  })
}

//查询所有货架
export function shelfListInfo(query) {
  return request({
    url: '/shelf/info/shelfListInfo',
    method: 'get',
    params: query
  })
}

// 查询料架信息详细
export function getInfo(fShelfId) {
  return request({
    url: '/shelf/info/' + fShelfId,
    method: 'get'
  })
}

// 新增料架信息
export function addInfo(data) {
  return request({
    url: '/shelf/info',
    method: 'post',
    data: data
  })
}

// 修改料架信息
export function updateInfo(data) {
  return request({
    url: '/shelf/info',
    method: 'put',
    data: data
  })
}

// 删除料架信息
export function delInfo(fShelfId) {
  return request({
    url: '/shelf/info/' + fShelfId,
    method: 'delete'
  })
}

// 导出料架信息
export function exportInfo(query) {
  return request({
    url: '/shelf/info/export',
    method: 'get',
    params: query
  })
}
