package com.zehong.system.service.shelf;

import java.util.List;
import com.zehong.system.domain.shelf.TPlatformDockingTask;

/**
 * 平台对接任务Service接口
 * 
 * @author zehong
 * @date 2025-09-22
 */
public interface ITPlatformDockingTaskService 
{
    /**
     * 查询平台对接任务
     * 
     * @param fId 平台对接任务ID
     * @return 平台对接任务
     */
    public TPlatformDockingTask selectTPlatformDockingTaskById(Long fId);

    /**
     * 查询平台对接任务列表
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 平台对接任务集合
     */
    public List<TPlatformDockingTask> selectTPlatformDockingTaskList(TPlatformDockingTask tPlatformDockingTask);

    /**
     * 新增平台对接任务
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 结果
     */
    public int insertTPlatformDockingTask(TPlatformDockingTask tPlatformDockingTask);

    /**
     * 修改平台对接任务
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 结果
     */
    public int updateTPlatformDockingTask(TPlatformDockingTask tPlatformDockingTask);

    /**
     * 批量删除平台对接任务
     * 
     * @param fIds 需要删除的平台对接任务ID
     * @return 结果
     */
    public int deleteTPlatformDockingTaskByIds(Long[] fIds);

    /**
     * 删除平台对接任务信息
     * 
     * @param fId 平台对接任务ID
     * @return 结果
     */
    public int deleteTPlatformDockingTaskById(Long fId);
}
