package com.zehong.system.service.impl.shelf;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.shelf.TPlatformDockingTaskMapper;
import com.zehong.system.domain.shelf.TPlatformDockingTask;
import com.zehong.system.service.shelf.ITPlatformDockingTaskService;

/**
 * 平台对接任务Service业务层处理
 * 
 * @author zehong
 * @date 2025-09-22
 */
@Service
public class TPlatformDockingTaskServiceImpl implements ITPlatformDockingTaskService 
{
    @Autowired
    private TPlatformDockingTaskMapper tPlatformDockingTaskMapper;

    /**
     * 查询平台对接任务
     * 
     * @param fId 平台对接任务ID
     * @return 平台对接任务
     */
    @Override
    public TPlatformDockingTask selectTPlatformDockingTaskById(Long fId)
    {
        return tPlatformDockingTaskMapper.selectTPlatformDockingTaskById(fId);
    }

    /**
     * 查询平台对接任务列表
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 平台对接任务
     */
    @Override
    public List<TPlatformDockingTask> selectTPlatformDockingTaskList(TPlatformDockingTask tPlatformDockingTask)
    {
        return tPlatformDockingTaskMapper.selectTPlatformDockingTaskList(tPlatformDockingTask);
    }

    /**
     * 新增平台对接任务
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 结果
     */
    @Override
    public int insertTPlatformDockingTask(TPlatformDockingTask tPlatformDockingTask)
    {
        return tPlatformDockingTaskMapper.insertTPlatformDockingTask(tPlatformDockingTask);
    }

    /**
     * 修改平台对接任务
     * 
     * @param tPlatformDockingTask 平台对接任务
     * @return 结果
     */
    @Override
    public int updateTPlatformDockingTask(TPlatformDockingTask tPlatformDockingTask)
    {
        return tPlatformDockingTaskMapper.updateTPlatformDockingTask(tPlatformDockingTask);
    }

    /**
     * 批量删除平台对接任务
     * 
     * @param fIds 需要删除的平台对接任务ID
     * @return 结果
     */
    @Override
    public int deleteTPlatformDockingTaskByIds(Long[] fIds)
    {
        return tPlatformDockingTaskMapper.deleteTPlatformDockingTaskByIds(fIds);
    }

    /**
     * 删除平台对接任务信息
     * 
     * @param fId 平台对接任务ID
     * @return 结果
     */
    @Override
    public int deleteTPlatformDockingTaskById(Long fId)
    {
        return tPlatformDockingTaskMapper.deleteTPlatformDockingTaskById(fId);
    }
}
