package com.zehong.system.service.impl.shelf;

import com.alibaba.fastjson.JSONObject;
import com.zehong.system.domain.shelf.TShelfInfo;
import com.zehong.system.mapper.shelf.TShelfInfoMapper;
import com.zehong.system.service.shelf.ITShelfApiService;
import com.zehong.system.service.shelf.ITShelfInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 料架信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-09-20
 */
@Service
public class TShelfInfoServiceImpl implements ITShelfInfoService 
{
    @Resource
    private TShelfInfoMapper tShelfInfoMapper;

    @Autowired
    private ITShelfApiService shelfApiService;

    /**
     * 查询料架信息
     * 
     * @param fShelfId 料架信息ID
     * @return 料架信息
     */
    @Override
    public TShelfInfo selectTShelfInfoById(Long fShelfId)
    {
        return tShelfInfoMapper.selectTShelfInfoById(fShelfId);
    }

    /**
     * 查询料架信息列表
     * 
     * @param tShelfInfo 料架信息
     * @return 料架信息
     */
    @Override
    public List<TShelfInfo> selectTShelfInfoList(TShelfInfo tShelfInfo) {
        List<TShelfInfo> shelfInfoList = tShelfInfoMapper.selectTShelfInfoList(tShelfInfo);
        for(TShelfInfo shelfInfo : shelfInfoList){
            JSONObject param = new JSONObject();
            param.put("SHELF",shelfInfo.getfShelf());
            JSONObject statusResult = shelfApiService.getRackStatus(param.toJSONString());
            shelfInfo.setfStatus(statusResult.getInteger("STATUS"));
        }
        return shelfInfoList;
    }

    /**
     * 新增料架信息
     * 
     * @param tShelfInfo 料架信息
     * @return 结果
     */
    @Override
    public int insertTShelfInfo(TShelfInfo tShelfInfo)
    {
        return tShelfInfoMapper.insertTShelfInfo(tShelfInfo);
    }

    /**
     * 修改料架信息
     * 
     * @param tShelfInfo 料架信息
     * @return 结果
     */
    @Override
    public int updateTShelfInfo(TShelfInfo tShelfInfo)
    {
        return tShelfInfoMapper.updateTShelfInfo(tShelfInfo);
    }

    /**
     * 批量删除料架信息
     * 
     * @param fShelfIds 需要删除的料架信息ID
     * @return 结果
     */
    @Override
    public int deleteTShelfInfoByIds(Long[] fShelfIds)
    {
        return tShelfInfoMapper.deleteTShelfInfoByIds(fShelfIds);
    }

    /**
     * 删除料架信息信息
     * 
     * @param fShelfId 料架信息ID
     * @return 结果
     */
    @Override
    public int deleteTShelfInfoById(Long fShelfId)
    {
        return tShelfInfoMapper.deleteTShelfInfoById(fShelfId);
    }
}
