package com.zehong.system.mapper.shelf;

import java.util.List;
import com.zehong.system.domain.shelf.TShelfStorageLocation;

/**
 * 储位信息Mapper接口
 * 
 * @author zehong
 * @date 2025-09-20
 */
public interface TShelfStorageLocationMapper 
{
    /**
     * 查询储位信息
     * 
     * @param fShelfStorageLocationId 储位信息ID
     * @return 储位信息
     */
    public TShelfStorageLocation selectTShelfStorageLocationById(Long fShelfStorageLocationId);

    /**
     * 查询储位信息列表
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 储位信息集合
     */
    public List<TShelfStorageLocation> selectTShelfStorageLocationList(TShelfStorageLocation tShelfStorageLocation);

    /**
     * 新增储位信息
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 结果
     */
    public int insertTShelfStorageLocation(TShelfStorageLocation tShelfStorageLocation);

    /**
     * 修改储位信息
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 结果
     */
    public int updateTShelfStorageLocation(TShelfStorageLocation tShelfStorageLocation);

    /**
     * 删除储位信息
     * 
     * @param fShelfStorageLocationId 储位信息ID
     * @return 结果
     */
    public int deleteTShelfStorageLocationById(Long fShelfStorageLocationId);

    /**
     * 批量删除储位信息
     * 
     * @param fShelfStorageLocationIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTShelfStorageLocationByIds(Long[] fShelfStorageLocationIds);

    /**
     * 根据位置更新储位信息
     * @param tShelfStorageLocation
     * @return
     */
    int updateTShelfStorageLocationByLocationAndShelfId(TShelfStorageLocation tShelfStorageLocation);
}
