package com.zehong.web.controller.shelf;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.shelf.TPlatformDockingTask;
import com.zehong.system.service.shelf.ITPlatformDockingTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 平台对接任务Controller
 * 
 * @author zehong
 * @date 2025-09-22
 */
@RestController
@RequestMapping("/shelf/docking")
public class TPlatformDockingTaskController extends BaseController
{
    @Autowired
    private ITPlatformDockingTaskService tPlatformDockingTaskService;

    /**
     * 查询平台对接任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPlatformDockingTask tPlatformDockingTask)
    {
        startPage();
        List<TPlatformDockingTask> list = tPlatformDockingTaskService.selectTPlatformDockingTaskList(tPlatformDockingTask);
        return getDataTable(list);
    }

    /**
     * 导出平台对接任务列表
     */
    @Log(title = "平台对接任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPlatformDockingTask tPlatformDockingTask)
    {
        List<TPlatformDockingTask> list = tPlatformDockingTaskService.selectTPlatformDockingTaskList(tPlatformDockingTask);
        ExcelUtil<TPlatformDockingTask> util = new ExcelUtil<TPlatformDockingTask>(TPlatformDockingTask.class);
        return util.exportExcel(list, "平台对接任务数据");
    }

    /**
     * 获取平台对接任务详细信息
     */
    @GetMapping(value = "/{fId}")
    public AjaxResult getInfo(@PathVariable("fId") Long fId)
    {
        return AjaxResult.success(tPlatformDockingTaskService.selectTPlatformDockingTaskById(fId));
    }

    /**
     * 新增平台对接任务
     */
    @Log(title = "平台对接任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPlatformDockingTask tPlatformDockingTask)
    {
        return toAjax(tPlatformDockingTaskService.insertTPlatformDockingTask(tPlatformDockingTask));
    }

    /**
     * 修改平台对接任务
     */
    @Log(title = "平台对接任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPlatformDockingTask tPlatformDockingTask)
    {
        return toAjax(tPlatformDockingTaskService.updateTPlatformDockingTask(tPlatformDockingTask));
    }

    /**
     * 删除平台对接任务
     */
    @Log(title = "平台对接任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fIds}")
    public AjaxResult remove(@PathVariable Long[] fIds)
    {
        return toAjax(tPlatformDockingTaskService.deleteTPlatformDockingTaskByIds(fIds));
    }
}
