import request from '@/utils/request'

// 查询料架和物料维护列表
export function listRelation(query) {
  return request({
    url: '/material/relation/list',
    method: 'get',
    params: query
  })
}

//查询所有
export function relationListInfo(query) {
  return request({
    url: '/material/relation/relationListInfo',
    method: 'get',
    params: query
  })
}

// 查询料架和物料维护详细
export function getRelation(relationId) {
  return request({
    url: '/material/relation/' + relationId,
    method: 'get'
  })
}

// 新增料架和物料维护
export function addRelation(data) {
  return request({
    url: '/material/relation',
    method: 'post',
    data: data
  })
}

// 修改料架和物料维护
export function updateRelation(data) {
  return request({
    url: '/material/relation',
    method: 'put',
    data: data
  })
}

// 删除料架和物料维护
export function delRelation(relationId) {
  return request({
    url: '/material/relation/' + relationId,
    method: 'delete'
  })
}

// 导出料架和物料维护
export function exportRelation(query) {
  return request({
    url: '/material/relation/export',
    method: 'get',
    params: query
  })
}
