import request from '@/utils/request'

// 查询物料维护列表
export function listInfo(query) {
  return request({
    url: '/material/info/list',
    method: 'get',
    params: query
  })
}

// 查询所有物料信息
export function materialInfoList(query) {
  return request({
    url: '/material/info/materialInfoList',
    method: 'get',
    params: query
  })
}

// 查询物料维护详细
export function getInfo(materialId) {
  return request({
    url: '/material/info/' + materialId,
    method: 'get'
  })
}

// 新增物料维护
export function addInfo(data) {
  return request({
    url: '/material/info',
    method: 'post',
    data: data
  })
}

// 修改物料维护
export function updateInfo(data) {
  return request({
    url: '/material/info',
    method: 'put',
    data: data
  })
}

// 删除物料维护
export function delInfo(materialId) {
  return request({
    url: '/material/info/' + materialId,
    method: 'delete'
  })
}

// 导出物料维护
export function exportInfo(query) {
  return request({
    url: '/material/info/export',
    method: 'get',
    params: query
  })
}
