package com.zehong.system.service.shelf;

import java.util.List;
import com.zehong.system.domain.material.TRackMaterialRelation;

/**
 * 料架和物料维护Service接口
 * 
 * @author zehong
 * @date 2025-09-24
 */
public interface ITRackMaterialRelationService 
{
    /**
     * 查询料架和物料维护
     * 
     * @param relationId 料架和物料维护ID
     * @return 料架和物料维护
     */
    public TRackMaterialRelation selectTRackMaterialRelationById(Long relationId);

    /**
     * 查询料架和物料维护列表
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 料架和物料维护集合
     */
    public List<TRackMaterialRelation> selectTRackMaterialRelationList(TRackMaterialRelation tRackMaterialRelation);

    /**
     * 新增料架和物料维护
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 结果
     */
    public int insertTRackMaterialRelation(TRackMaterialRelation tRackMaterialRelation);

    /**
     * 修改料架和物料维护
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 结果
     */
    public int updateTRackMaterialRelation(TRackMaterialRelation tRackMaterialRelation);

    /**
     * 批量删除料架和物料维护
     * 
     * @param relationIds 需要删除的料架和物料维护ID
     * @return 结果
     */
    public int deleteTRackMaterialRelationByIds(Long[] relationIds);

    /**
     * 删除料架和物料维护信息
     * 
     * @param relationId 料架和物料维护ID
     * @return 结果
     */
    public int deleteTRackMaterialRelationById(Long relationId);
}
