package com.zehong.system.service.material;

import java.util.List;
import com.zehong.system.domain.material.TRackMaterialInfo;

/**
 * 物料维护Service接口
 * 
 * @author zehong
 * @date 2025-10-16
 */
public interface ITRackMaterialInfoService 
{
    /**
     * 查询物料维护
     * 
     * @param materialId 物料维护ID
     * @return 物料维护
     */
    public TRackMaterialInfo selectTRackMaterialInfoById(Long materialId);

    /**
     * 查询物料维护列表
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 物料维护集合
     */
    public List<TRackMaterialInfo> selectTRackMaterialInfoList(TRackMaterialInfo tRackMaterialInfo);

    /**
     * 新增物料维护
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 结果
     */
    public int insertTRackMaterialInfo(TRackMaterialInfo tRackMaterialInfo);

    /**
     * 修改物料维护
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 结果
     */
    public int updateTRackMaterialInfo(TRackMaterialInfo tRackMaterialInfo);

    /**
     * 批量删除物料维护
     * 
     * @param materialIds 需要删除的物料维护ID
     * @return 结果
     */
    public int deleteTRackMaterialInfoByIds(Long[] materialIds);

    /**
     * 删除物料维护信息
     * 
     * @param materialId 物料维护ID
     * @return 结果
     */
    public int deleteTRackMaterialInfoById(Long materialId);
}
