package com.zehong.system.service.impl.material;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.material.TRackMaterialInfoMapper;
import com.zehong.system.domain.material.TRackMaterialInfo;
import com.zehong.system.service.material.ITRackMaterialInfoService;

/**
 * 物料维护Service业务层处理
 * 
 * @author zehong
 * @date 2025-10-16
 */
@Service
public class TRackMaterialInfoServiceImpl implements ITRackMaterialInfoService 
{
    @Autowired
    private TRackMaterialInfoMapper tRackMaterialInfoMapper;

    /**
     * 查询物料维护
     * 
     * @param materialId 物料维护ID
     * @return 物料维护
     */
    @Override
    public TRackMaterialInfo selectTRackMaterialInfoById(Long materialId)
    {
        return tRackMaterialInfoMapper.selectTRackMaterialInfoById(materialId);
    }

    /**
     * 查询物料维护列表
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 物料维护
     */
    @Override
    public List<TRackMaterialInfo> selectTRackMaterialInfoList(TRackMaterialInfo tRackMaterialInfo)
    {
        return tRackMaterialInfoMapper.selectTRackMaterialInfoList(tRackMaterialInfo);
    }

    /**
     * 新增物料维护
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 结果
     */
    @Override
    public int insertTRackMaterialInfo(TRackMaterialInfo tRackMaterialInfo)
    {
        tRackMaterialInfo.setCreateTime(DateUtils.getNowDate());
        tRackMaterialInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        return tRackMaterialInfoMapper.insertTRackMaterialInfo(tRackMaterialInfo);
    }

    /**
     * 修改物料维护
     * 
     * @param tRackMaterialInfo 物料维护
     * @return 结果
     */
    @Override
    public int updateTRackMaterialInfo(TRackMaterialInfo tRackMaterialInfo)
    {
        tRackMaterialInfo.setUpdateTime(DateUtils.getNowDate());
        tRackMaterialInfo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        return tRackMaterialInfoMapper.updateTRackMaterialInfo(tRackMaterialInfo);
    }

    /**
     * 批量删除物料维护
     * 
     * @param materialIds 需要删除的物料维护ID
     * @return 结果
     */
    @Override
    public int deleteTRackMaterialInfoByIds(Long[] materialIds)
    {
        return tRackMaterialInfoMapper.deleteTRackMaterialInfoByIds(materialIds);
    }

    /**
     * 删除物料维护信息
     * 
     * @param materialId 物料维护ID
     * @return 结果
     */
    @Override
    public int deleteTRackMaterialInfoById(Long materialId)
    {
        return tRackMaterialInfoMapper.deleteTRackMaterialInfoById(materialId);
    }
}
