package com.zehong.system.mapper.system;

import java.util.List;
import com.zehong.system.domain.system.SysSetting;

/**
 * 系统参数配置Mapper接口
 * 
 * @author zehong
 * @date 2021-11-23
 */
public interface SysSettingMapper 
{
    /**
     * 查询系统参数配置
     * 
     * @param systemId 系统参数配置ID
     * @return 系统参数配置
     */
    public SysSetting selectSysSettingById(Integer systemId);

    /**
     * 查询系统参数配置列表
     * 
     * @param sysSetting 系统参数配置
     * @return 系统参数配置集合
     */
    public List<SysSetting> selectSysSettingList(SysSetting sysSetting);

    /**
     * 新增系统参数配置
     * 
     * @param sysSetting 系统参数配置
     * @return 结果
     */
    public int insertSysSetting(SysSetting sysSetting);

    /**
     * 修改系统参数配置
     * 
     * @param sysSetting 系统参数配置
     * @return 结果
     */
    public int updateSysSetting(SysSetting sysSetting);

    /**
     * 删除系统参数配置
     * 
     * @param systemId 系统参数配置ID
     * @return 结果
     */
    public int deleteSysSettingById(Integer systemId);

    /**
     * 批量删除系统参数配置
     * 
     * @param systemIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteSysSettingByIds(Integer[] systemIds);
}
