package com.zehong.system.domain.system;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 系统参数配置对象 sys_setting
 * 
 * @author zehong
 * @date 2021-11-23
 */
public class SysSetting extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 参数主键 */
    private Integer systemId;

    /** 参数名称 */
    @Excel(name = "参数名称")
    private String systemName;

    /** 参数键名 */
    @Excel(name = "参数键名")
    private String systemKey;

    /** 参数键值 */
    @Excel(name = "参数键值")
    private String systemValue;

    /** 系统类型（0后台 1前台） */
    @Excel(name = "系统类型", readConverterExp = "0=后台,1=前台")
    private String systemType;

    /** 0启用 1禁用 */
    @Excel(name = "0启用 1禁用")
    private String isDel;

    public void setSystemId(Integer systemId) 
    {
        this.systemId = systemId;
    }

    public Integer getSystemId() 
    {
        return systemId;
    }
    public void setSystemName(String systemName) 
    {
        this.systemName = systemName;
    }

    public String getSystemName() 
    {
        return systemName;
    }
    public void setSystemKey(String systemKey) 
    {
        this.systemKey = systemKey;
    }

    public String getSystemKey() 
    {
        return systemKey;
    }
    public void setSystemValue(String systemValue) 
    {
        this.systemValue = systemValue;
    }

    public String getSystemValue() 
    {
        return systemValue;
    }
    public void setSystemType(String systemType) 
    {
        this.systemType = systemType;
    }

    public String getSystemType() 
    {
        return systemType;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("systemId", getSystemId())
            .append("systemName", getSystemName())
            .append("systemKey", getSystemKey())
            .append("systemValue", getSystemValue())
            .append("systemType", getSystemType())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .toString();
    }
}
