package com.zehong.web.controller.material;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.material.TRackMaterialRelation;
import com.zehong.system.service.shelf.ITRackMaterialRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 料架和物料维护Controller
 * 
 * @author zehong
 * @date 2025-09-24
 */
@RestController
@RequestMapping("/material/relation")
public class TRackMaterialRelationController extends BaseController
{
    @Autowired
    private ITRackMaterialRelationService tRackMaterialRelationService;

    /**
     * 查询料架和物料维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TRackMaterialRelation tRackMaterialRelation)
    {
        startPage();
        List<TRackMaterialRelation> list = tRackMaterialRelationService.selectTRackMaterialRelationList(tRackMaterialRelation);
        return getDataTable(list);
    }


    @GetMapping("/relationListInfo")
    public AjaxResult relationListInfo(TRackMaterialRelation tRackMaterialRelation)
    {
        List<TRackMaterialRelation> list = tRackMaterialRelationService.selectTRackMaterialRelationList(tRackMaterialRelation);
        return AjaxResult.success(list);
    }

    /**
     * 导出料架和物料维护列表
     */
    @Log(title = "料架和物料维护", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TRackMaterialRelation tRackMaterialRelation)
    {
        List<TRackMaterialRelation> list = tRackMaterialRelationService.selectTRackMaterialRelationList(tRackMaterialRelation);
        ExcelUtil<TRackMaterialRelation> util = new ExcelUtil<TRackMaterialRelation>(TRackMaterialRelation.class);
        return util.exportExcel(list, "料架和物料维护数据");
    }

    /**
     * 获取料架和物料维护详细信息
     */
    @GetMapping(value = "/{relationId}")
    public AjaxResult getInfo(@PathVariable("relationId") Long relationId)
    {
        return AjaxResult.success(tRackMaterialRelationService.selectTRackMaterialRelationById(relationId));
    }

    /**
     * 新增料架和物料维护
     */
    @Log(title = "料架和物料维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TRackMaterialRelation tRackMaterialRelation)
    {
        return toAjax(tRackMaterialRelationService.insertTRackMaterialRelation(tRackMaterialRelation));
    }

    /**
     * 修改料架和物料维护
     */
    @Log(title = "料架和物料维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TRackMaterialRelation tRackMaterialRelation)
    {
        return toAjax(tRackMaterialRelationService.updateTRackMaterialRelation(tRackMaterialRelation));
    }

    /**
     * 删除料架和物料维护
     */
    @Log(title = "料架和物料维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{relationIds}")
    public AjaxResult remove(@PathVariable Long[] relationIds)
    {
        return toAjax(tRackMaterialRelationService.deleteTRackMaterialRelationByIds(relationIds));
    }
}
