package com.zehong.web.controller.material;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.material.TRackMaterialInfo;
import com.zehong.system.service.material.ITRackMaterialInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 物料维护Controller
 * 
 * @author zehong
 * @date 2025-10-16
 */
@RestController
@RequestMapping("/material/info")
public class TRackMaterialInfoController extends BaseController
{
    @Autowired
    private ITRackMaterialInfoService tRackMaterialInfoService;

    /**
     * 查询物料维护列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TRackMaterialInfo tRackMaterialInfo)
    {
        startPage();
        List<TRackMaterialInfo> list = tRackMaterialInfoService.selectTRackMaterialInfoList(tRackMaterialInfo);
        return getDataTable(list);
    }

    /**
     * 查询物料维护列表信息
     */
    @GetMapping("/materialInfoList")
    public AjaxResult materialInfoList(TRackMaterialInfo tRackMaterialInfo) {
        List<TRackMaterialInfo> list = tRackMaterialInfoService.selectTRackMaterialInfoList(tRackMaterialInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出物料维护列表
     */
    @Log(title = "物料维护", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TRackMaterialInfo tRackMaterialInfo)
    {
        List<TRackMaterialInfo> list = tRackMaterialInfoService.selectTRackMaterialInfoList(tRackMaterialInfo);
        ExcelUtil<TRackMaterialInfo> util = new ExcelUtil<TRackMaterialInfo>(TRackMaterialInfo.class);
        return util.exportExcel(list, "物料维护数据");
    }

    /**
     * 获取物料维护详细信息
     */
    @GetMapping(value = "/{materialId}")
    public AjaxResult getInfo(@PathVariable("materialId") Long materialId)
    {
        return AjaxResult.success(tRackMaterialInfoService.selectTRackMaterialInfoById(materialId));
    }

    /**
     * 新增物料维护
     */
    @Log(title = "物料维护", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TRackMaterialInfo tRackMaterialInfo)
    {
        return toAjax(tRackMaterialInfoService.insertTRackMaterialInfo(tRackMaterialInfo));
    }

    /**
     * 修改物料维护
     */
    @Log(title = "物料维护", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TRackMaterialInfo tRackMaterialInfo)
    {
        return toAjax(tRackMaterialInfoService.updateTRackMaterialInfo(tRackMaterialInfo));
    }

    /**
     * 删除物料维护
     */
    @Log(title = "物料维护", businessType = BusinessType.DELETE)
	@DeleteMapping("/{materialIds}")
    public AjaxResult remove(@PathVariable Long[] materialIds)
    {
        return toAjax(tRackMaterialInfoService.deleteTRackMaterialInfoByIds(materialIds));
    }
}
