package com.zehong.system.mapper.shelf;

import java.util.List;
import com.zehong.system.domain.shelf.TShelfInfo;

/**
 * 料架信息Mapper接口
 * 
 * @author zehong
 * @date 2025-09-20
 */
public interface TShelfInfoMapper 
{
    /**
     * 查询料架信息
     * 
     * @param fShelfId 料架信息ID
     * @return 料架信息
     */
    public TShelfInfo selectTShelfInfoById(Long fShelfId);


    /**
     * 根据料架名称获取料架信息
     * @param shelf 料架名称
     * @return
     */
    TShelfInfo selectTShelfInfoByShelf(String shelf);

    /**
     * 查询料架信息列表
     * 
     * @param tShelfInfo 料架信息
     * @return 料架信息集合
     */
    public List<TShelfInfo> selectTShelfInfoList(TShelfInfo tShelfInfo);

    /**
     * 新增料架信息
     * 
     * @param tShelfInfo 料架信息
     * @return 结果
     */
    public int insertTShelfInfo(TShelfInfo tShelfInfo);

    /**
     * 修改料架信息
     * 
     * @param tShelfInfo 料架信息
     * @return 结果
     */
    public int updateTShelfInfo(TShelfInfo tShelfInfo);

    /**
     * 删除料架信息
     * 
     * @param fShelfId 料架信息ID
     * @return 结果
     */
    public int deleteTShelfInfoById(Long fShelfId);

    /**
     * 批量删除料架信息
     * 
     * @param fShelfIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTShelfInfoByIds(Long[] fShelfIds);
}
