package com.zehong.system.domain.shelf;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 平台对接任务对象 t_platform_docking_task
 * 
 * @author zehong
 * @date 2025-09-22
 */
public class TPlatformDockingTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 自增主键ID */
    private Long fId;

    /** 任务号，对应请求体中的ID */
    @Excel(name = "任务号，对应请求体中的ID")
    private String fTaskId;

    /** 操作类型，对应OPTYPE：N/I/O/C/S/D */
    @Excel(name = "操作类型，对应OPTYPE：N/I/O/C/S/D")
    private String fOpType;

    /** 料架号，对应SHELF */
    @Excel(name = "料架号，对应SHELF")
    private String fShelf;

    /** 颜色标识，对应COLOR */
    @Excel(name = "颜色标识，对应COLOR")
    private String fColor;

    /** 接口类型-(0-调用料架系统接口；1-客户接口返回) */
    @Excel(name = "接口类型-(0-调用料架系统接口；1-客户接口返回)")
    private Integer fType;

    /** 储位编号 */
    @Excel(name = "储位编号")
    private String fLocation;

    /** 料盘唯一码 */
    @Excel(name = "料盘唯一码")
    private String fRid;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fOperateDate;

    /** 操作人，对应USERNAME */
    @Excel(name = "操作人，对应USERNAME")
    private String fUsername;

    /** 料盘与储位信息集合，对应TOTALINFO */
    @Excel(name = "料盘与储位信息集合，对应TOTALINFO")
    private String fTotalInfo;

    /** 任务请求时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "任务请求时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fRequestTime;

    /** 返回信息，返回结果 */
    @Excel(name = "返回信息，返回结果")
    private String fResponseInfo;

    public void setfId(Long fId) 
    {
        this.fId = fId;
    }

    public Long getfId() 
    {
        return fId;
    }
    public void setfTaskId(String fTaskId) 
    {
        this.fTaskId = fTaskId;
    }

    public String getfTaskId() 
    {
        return fTaskId;
    }
    public void setfOpType(String fOpType) 
    {
        this.fOpType = fOpType;
    }

    public String getfOpType() 
    {
        return fOpType;
    }
    public void setfShelf(String fShelf) 
    {
        this.fShelf = fShelf;
    }

    public String getfShelf() 
    {
        return fShelf;
    }
    public void setfColor(String fColor) 
    {
        this.fColor = fColor;
    }

    public String getfColor() 
    {
        return fColor;
    }
    public void setfType(Integer fType) 
    {
        this.fType = fType;
    }

    public Integer getfType() 
    {
        return fType;
    }
    public void setfLocation(String fLocation) 
    {
        this.fLocation = fLocation;
    }

    public String getfLocation() 
    {
        return fLocation;
    }
    public void setfRid(String fRid) 
    {
        this.fRid = fRid;
    }

    public String getfRid() 
    {
        return fRid;
    }
    public void setfOperateDate(Date fOperateDate) 
    {
        this.fOperateDate = fOperateDate;
    }

    public Date getfOperateDate() 
    {
        return fOperateDate;
    }
    public void setfUsername(String fUsername) 
    {
        this.fUsername = fUsername;
    }

    public String getfUsername() 
    {
        return fUsername;
    }
    public void setfTotalInfo(String fTotalInfo) 
    {
        this.fTotalInfo = fTotalInfo;
    }

    public String getfTotalInfo() 
    {
        return fTotalInfo;
    }
    public void setfRequestTime(Date fRequestTime) 
    {
        this.fRequestTime = fRequestTime;
    }

    public Date getfRequestTime() 
    {
        return fRequestTime;
    }
    public void setfResponseInfo(String fResponseInfo) 
    {
        this.fResponseInfo = fResponseInfo;
    }

    public String getfResponseInfo() 
    {
        return fResponseInfo;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fId", getfId())
            .append("fTaskId", getfTaskId())
            .append("fOpType", getfOpType())
            .append("fShelf", getfShelf())
            .append("fColor", getfColor())
            .append("fType", getfType())
            .append("fLocation", getfLocation())
            .append("fRid", getfRid())
            .append("fOperateDate", getfOperateDate())
            .append("fUsername", getfUsername())
            .append("fTotalInfo", getfTotalInfo())
            .append("fRequestTime", getfRequestTime())
            .append("fResponseInfo", getfResponseInfo())
            .toString();
    }
}
