package com.zehong.web.controller.shelf;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.shelf.TShelfStorageLocation;
import com.zehong.system.service.shelf.ITShelfApiService;
import com.zehong.system.service.shelf.ITShelfStorageLocationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.List;

/**
 * 储位信息Controller
 * 
 * @author zehong
 * @date 2025-09-20
 */
@RestController
@RequestMapping("/shelf/location")
public class TShelfStorageLocationController extends BaseController
{
    @Autowired
    private ITShelfStorageLocationService tShelfStorageLocationService;

    @Autowired
    private ITShelfApiService shelfApiService;

    /**
     * 查询储位信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TShelfStorageLocation tShelfStorageLocation)
    {
        startPage();
        List<TShelfStorageLocation> list = tShelfStorageLocationService.selectTShelfStorageLocationList(tShelfStorageLocation);
        return getDataTable(list);
    }

    /**
     * 查询料架信息列表
     */
    @GetMapping("/locationListInfo")
    public AjaxResult locationListInfo(TShelfStorageLocation tShelfStorageLocation) {
        List<TShelfStorageLocation> list = tShelfStorageLocationService.selectTShelfStorageLocationList(tShelfStorageLocation);
        return AjaxResult.success(list);
    }

    /**
     * 导出储位信息列表
     */
    @Log(title = "储位信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TShelfStorageLocation tShelfStorageLocation)
    {
        List<TShelfStorageLocation> list = tShelfStorageLocationService.selectTShelfStorageLocationList(tShelfStorageLocation);
        ExcelUtil<TShelfStorageLocation> util = new ExcelUtil<TShelfStorageLocation>(TShelfStorageLocation.class);
        return util.exportExcel(list, "储位信息数据");
    }

    /**
     * 获取储位信息详细信息
     */
    @GetMapping(value = "/{fShelfStorageLocationId}")
    public AjaxResult getInfo(@PathVariable("fShelfStorageLocationId") Long fShelfStorageLocationId)
    {
        return AjaxResult.success(tShelfStorageLocationService.selectTShelfStorageLocationById(fShelfStorageLocationId));
    }

    /**
     * 新增储位信息
     */
    @Log(title = "储位信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TShelfStorageLocation tShelfStorageLocation)
    {
        return toAjax(tShelfStorageLocationService.insertTShelfStorageLocation(tShelfStorageLocation));
    }

    /**
     * 修改储位信息
     */
    @Log(title = "储位信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TShelfStorageLocation tShelfStorageLocation)
    {
        return toAjax(tShelfStorageLocationService.updateTShelfStorageLocation(tShelfStorageLocation));
    }

    /**
     * 删除储位信息
     */
    @Log(title = "储位信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fShelfStorageLocationIds}")
    public AjaxResult remove(@PathVariable Long[] fShelfStorageLocationIds)
    {
        return toAjax(tShelfStorageLocationService.deleteTShelfStorageLocationByIds(fShelfStorageLocationIds));
    }

    /**
     * 出入库
     * @param param 参数
     * @return
     */
    @PostMapping("/rackInOutput")
    public AjaxResult rackInOutput(@RequestBody String param) {
        String result = shelfApiService.rackInOutput(param);
        JSONObject resultJson = JSONObject.parseObject(result);
        if("1".equals(resultJson.getString("FLAG"))) {
            return AjaxResult.error(resultJson.getString("MESSAGE"));
        }
        return AjaxResult.success();
    }

    @PostMapping("/receiveFeedBackInfo")
    public AjaxResult receiveFeedBackInfo(@RequestBody JSONObject request){
        try {
            return AjaxResult.success(shelfApiService.receiveFeedBackInfo(request));
        } catch (ParseException e) {
            return AjaxResult.error("反馈接口调用失败");
        }
    }
}
