package com.zehong.web.controller.shelf;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.shelf.TShelfInfo;
import com.zehong.system.service.shelf.ITShelfInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 料架信息Controller
 * 
 * @author zehong
 * @date 2025-09-20
 */
@RestController
@RequestMapping("/shelf/info")
public class TShelfInfoController extends BaseController
{
    @Autowired
    private ITShelfInfoService tShelfInfoService;

    /**
     * 查询料架信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TShelfInfo tShelfInfo)
    {
        startPage();
        List<TShelfInfo> list = tShelfInfoService.selectTShelfInfoList(tShelfInfo);
        return getDataTable(list);
    }

    /**
     * 查询料架信息列表
     */
    @GetMapping("/shelfListInfo")
    public AjaxResult shelfListInfo(TShelfInfo tShelfInfo)
    {
        List<TShelfInfo> list = tShelfInfoService.selectTShelfInfoList(tShelfInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出料架信息列表
     */
    @Log(title = "料架信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TShelfInfo tShelfInfo)
    {
        List<TShelfInfo> list = tShelfInfoService.selectTShelfInfoList(tShelfInfo);
        ExcelUtil<TShelfInfo> util = new ExcelUtil<TShelfInfo>(TShelfInfo.class);
        return util.exportExcel(list, "料架信息数据");
    }

    /**
     * 获取料架信息详细信息
     */
    @GetMapping(value = "/{fShelfId}")
    public AjaxResult getInfo(@PathVariable("fShelfId") Long fShelfId)
    {
        return AjaxResult.success(tShelfInfoService.selectTShelfInfoById(fShelfId));
    }

    /**
     * 新增料架信息
     */
    @Log(title = "料架信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TShelfInfo tShelfInfo)
    {
        return toAjax(tShelfInfoService.insertTShelfInfo(tShelfInfo));
    }

    /**
     * 修改料架信息
     */
    @Log(title = "料架信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TShelfInfo tShelfInfo)
    {
        return toAjax(tShelfInfoService.updateTShelfInfo(tShelfInfo));
    }

    /**
     * 删除料架信息
     */
    @Log(title = "料架信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fShelfIds}")
    public AjaxResult remove(@PathVariable Long[] fShelfIds)
    {
        return toAjax(tShelfInfoService.deleteTShelfInfoByIds(fShelfIds));
    }
}
