import request from '@/utils/request'

// 查询储位信息列表
export function listLocation(query) {
  return request({
    url: '/shelf/location/list',
    method: 'get',
    params: query
  })
}

// 查询储位信息列表
export function locationListInfo(query) {
  return request({
    url: '/shelf/location/locationListInfo',
    method: 'get',
    params: query
  })
}

// 查询储位信息详细
export function getLocation(fShelfStorageLocationId) {
  return request({
    url: '/shelf/location/' + fShelfStorageLocationId,
    method: 'get'
  })
}

// 新增储位信息
export function addLocation(data) {
  return request({
    url: '/shelf/location',
    method: 'post',
    data: data
  })
}

// 修改储位信息
export function updateLocation(data) {
  return request({
    url: '/shelf/location',
    method: 'put',
    data: data
  })
}

// 删除储位信息
export function delLocation(fShelfStorageLocationId) {
  return request({
    url: '/shelf/location/' + fShelfStorageLocationId,
    method: 'delete'
  })
}

// 导出储位信息
export function exportLocation(query) {
  return request({
    url: '/shelf/location/export',
    method: 'get',
    params: query
  })
}

// 出入库
export function rackInOutput(data) {
  return request({
    url: '/shelf/location/rackInOutput',
    method: 'post',
    data: data
  })
}
