package com.zehong.system.service.impl.shelf;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.shelf.TShelfStorageLocationMapper;
import com.zehong.system.domain.shelf.TShelfStorageLocation;
import com.zehong.system.service.shelf.ITShelfStorageLocationService;

/**
 * 储位信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-09-20
 */
@Service
public class TShelfStorageLocationServiceImpl implements ITShelfStorageLocationService 
{
    @Autowired
    private TShelfStorageLocationMapper tShelfStorageLocationMapper;

    /**
     * 查询储位信息
     * 
     * @param fShelfStorageLocationId 储位信息ID
     * @return 储位信息
     */
    @Override
    public TShelfStorageLocation selectTShelfStorageLocationById(Long fShelfStorageLocationId)
    {
        return tShelfStorageLocationMapper.selectTShelfStorageLocationById(fShelfStorageLocationId);
    }

    /**
     * 查询储位信息列表
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 储位信息
     */
    @Override
    public List<TShelfStorageLocation> selectTShelfStorageLocationList(TShelfStorageLocation tShelfStorageLocation)
    {
        return tShelfStorageLocationMapper.selectTShelfStorageLocationList(tShelfStorageLocation);
    }

    /**
     * 新增储位信息
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 结果
     */
    @Override
    public int insertTShelfStorageLocation(TShelfStorageLocation tShelfStorageLocation)
    {
        return tShelfStorageLocationMapper.insertTShelfStorageLocation(tShelfStorageLocation);
    }

    /**
     * 修改储位信息
     * 
     * @param tShelfStorageLocation 储位信息
     * @return 结果
     */
    @Override
    public int updateTShelfStorageLocation(TShelfStorageLocation tShelfStorageLocation)
    {
        return tShelfStorageLocationMapper.updateTShelfStorageLocation(tShelfStorageLocation);
    }

    /**
     * 批量删除储位信息
     * 
     * @param fShelfStorageLocationIds 需要删除的储位信息ID
     * @return 结果
     */
    @Override
    public int deleteTShelfStorageLocationByIds(Long[] fShelfStorageLocationIds)
    {
        return tShelfStorageLocationMapper.deleteTShelfStorageLocationByIds(fShelfStorageLocationIds);
    }

    /**
     * 删除储位信息信息
     * 
     * @param fShelfStorageLocationId 储位信息ID
     * @return 结果
     */
    @Override
    public int deleteTShelfStorageLocationById(Long fShelfStorageLocationId)
    {
        return tShelfStorageLocationMapper.deleteTShelfStorageLocationById(fShelfStorageLocationId);
    }
}
