package com.zehong.system.service.impl.shelf;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.shelf.TRackMaterialRelationMapper;
import com.zehong.system.domain.shelf.TRackMaterialRelation;
import com.zehong.system.service.shelf.ITRackMaterialRelationService;

/**
 * 料架和物料维护Service业务层处理
 * 
 * @author zehong
 * @date 2025-09-24
 */
@Service
public class TRackMaterialRelationServiceImpl implements ITRackMaterialRelationService 
{
    @Autowired
    private TRackMaterialRelationMapper tRackMaterialRelationMapper;

    /**
     * 查询料架和物料维护
     * 
     * @param relationId 料架和物料维护ID
     * @return 料架和物料维护
     */
    @Override
    public TRackMaterialRelation selectTRackMaterialRelationById(Long relationId)
    {
        return tRackMaterialRelationMapper.selectTRackMaterialRelationById(relationId);
    }

    /**
     * 查询料架和物料维护列表
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 料架和物料维护
     */
    @Override
    public List<TRackMaterialRelation> selectTRackMaterialRelationList(TRackMaterialRelation tRackMaterialRelation)
    {
        return tRackMaterialRelationMapper.selectTRackMaterialRelationList(tRackMaterialRelation);
    }

    /**
     * 新增料架和物料维护
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 结果
     */
    @Override
    public int insertTRackMaterialRelation(TRackMaterialRelation tRackMaterialRelation)
    {
        tRackMaterialRelation.setCreateTime(DateUtils.getNowDate());
        tRackMaterialRelation.setCreateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        return tRackMaterialRelationMapper.insertTRackMaterialRelation(tRackMaterialRelation);
    }

    /**
     * 修改料架和物料维护
     * 
     * @param tRackMaterialRelation 料架和物料维护
     * @return 结果
     */
    @Override
    public int updateTRackMaterialRelation(TRackMaterialRelation tRackMaterialRelation)
    {
        tRackMaterialRelation.setUpdateTime(DateUtils.getNowDate());
        tRackMaterialRelation.setUpdateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        return tRackMaterialRelationMapper.updateTRackMaterialRelation(tRackMaterialRelation);
    }

    /**
     * 批量删除料架和物料维护
     * 
     * @param relationIds 需要删除的料架和物料维护ID
     * @return 结果
     */
    @Override
    public int deleteTRackMaterialRelationByIds(Long[] relationIds)
    {
        return tRackMaterialRelationMapper.deleteTRackMaterialRelationByIds(relationIds);
    }

    /**
     * 删除料架和物料维护信息
     * 
     * @param relationId 料架和物料维护ID
     * @return 结果
     */
    @Override
    public int deleteTRackMaterialRelationById(Long relationId)
    {
        return tRackMaterialRelationMapper.deleteTRackMaterialRelationById(relationId);
    }
}
