package com.zehong.system.domain.shelf;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 储位信息对象 t_shelf_storage_location
 * 
 * @author zehong
 * @date 2025-09-20
 */
public class TShelfStorageLocation extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 储位记录唯一ID */
    private Long shelfStorageLocationId;

    /** 关联的料架ID，关联料架表的f_id */
    @Excel(name = "关联的料架ID，关联料架表的f_id")
    private Long shelfId;

    /** 储位标签 */
    @Excel(name = "储位标签")
    private String label;

    /** 储位编号 */
    @Excel(name = "储位编号")
    private String location;

    /** 排序位置 */
    @Excel(name = "排序位置")
    private Long index;

    /** 料盘唯一码 */
    @Excel(name = "料盘唯一码")
    private String rid;

    /** 入库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inboundTime;

    /** 出库时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出库时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date outboundTime;

    public Long getShelfStorageLocationId() {
        return shelfStorageLocationId;
    }

    public void setShelfStorageLocationId(Long shelfStorageLocationId) {
        this.shelfStorageLocationId = shelfStorageLocationId;
    }

    public Long getShelfId() {
        return shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getIndex() {
        return index;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public Date getInboundTime() {
        return inboundTime;
    }

    public void setInboundTime(Date inboundTime) {
        this.inboundTime = inboundTime;
    }

    public Date getOutboundTime() {
        return outboundTime;
    }

    public void setOutboundTime(Date outboundTime) {
        this.outboundTime = outboundTime;
    }



    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fShelfStorageLocationId", getShelfStorageLocationId())
            .append("fShelfId", getShelfId())
            .append("fLabel", getLabel())
            .append("fLocation", getLocation())
            .append("fIndex", getIndex())
            .append("fRid", getRid())
            .append("fInboundTime", getInboundTime())
            .append("fOutboundTime", getOutboundTime())
            .toString();
    }
}
