import request from '@/utils/request'

// 查询交易项目列表
export function listProject(query) {
  return request({
    url: '/trade/project/list',
    method: 'get',
    params: query
  })
}


export function selectTTradeProjectListByRoles(query) {
  return request({
    url: '/trade/project/selectTTradeProjectListByRoles',
    method: 'get',
    params: query
  })
}

// 查询交易项目详细
export function getProject(tradeId) {
  return request({
    url: '/trade/project/' + tradeId,
    method: 'get'
  })
}

// 新增交易项目
export function addProject(data) {
  return request({
    url: '/trade/project',
    method: 'post',
    data: data
  })
}

// 修改交易项目
export function updateProject(data) {
  return request({
    url: '/trade/project',
    method: 'put',
    data: data
  })
}

// 删除交易项目
export function delProject(tradeId) {
  return request({
    url: '/trade/project/' + tradeId,
    method: 'delete'
  })
}

// 导出交易项目
export function exportProject(query) {
  return request({
    url: '/trade/project/export',
    method: 'get',
    params: query
  })
}

//交易结算
export function settlementTrade(data) {
  return request({
    url: '/trade/project/settlementTrade',
    method: 'post',
    data: data
  })
}
