import request from '@/utils/request'

// 查询外部采购（报销）申请列表
export function listPurchase(query) {
  return request({
    url: '/system/purchase/list',
    method: 'get',
    params: query
  })
}

// 查询外部采购（报销）申请详细
export function getPurchase(purchaseId) {
  return request({
    url: '/system/purchase/' + purchaseId,
    method: 'get'
  })
}

// 新增外部采购（报销）申请
export function addPurchase(data) {
  return request({
    url: '/system/purchase',
    method: 'post',
    data: data
  })
}

// 修改外部采购（报销）申请
export function updatePurchase(data) {
  return request({
    url: '/system/purchase',
    method: 'put',
    data: data
  })
}

// 删除外部采购（报销）申请
export function delPurchase(purchaseId) {
  return request({
    url: '/system/purchase/' + purchaseId,
    method: 'delete'
  })
}

// 导出外部采购（报销）申请
export function exportPurchase(query) {
  return request({
    url: '/system/purchase/export',
    method: 'get',
    params: query
  })
}

export function approvalPurchase(data) {
  return request({
    url: '/system/purchase/approvalPurchase',
    method: 'post',
    data: data
  })
}
