import request from '@/utils/request'

// 查询交易项目列表
export function listProject(query) {
  return request({
    url: '/transaction/project/list',
    method: 'get',
    params: query
  })
}

//获取所有项目
export function getTransactionProjectList(query){
  return request({
    url: '/transaction/project/getTransactionProjectList',
    method: 'get',
    params: query
  })
}

// 查询交易项目详细
export function getProject(transactionId) {
  return request({
    url: '/transaction/project/' + transactionId,
    method: 'get'
  })
}

// 新增交易项目
export function addProject(data) {
  return request({
    url: '/transaction/project',
    method: 'post',
    data: data
  })
}

// 修改交易项目
export function updateProject(data) {
  return request({
    url: '/transaction/project',
    method: 'put',
    data: data
  })
}

// 删除交易项目
export function delProject(transactionId) {
  return request({
    url: '/transaction/project/' + transactionId,
    method: 'delete'
  })
}

// 导出交易项目
export function exportProject(query) {
  return request({
    url: '/transaction/project/export',
    method: 'get',
    params: query
  })
}

// 下载导入模板
export function importTemplate() {
  return request({
    url: '/transaction/project/importTemplate',
    method: 'get'
  })
}
