import request from '@/utils/request'

// 查询借支申请列表
export function listFor(query) {
  return request({
    url: '/system/for/list',
    method: 'get',
    params: query
  })
}

//查询部门余额是否足够
export function getDepartmentBalance(data) {
  return request({
    url: '/system/for/departmentBalance',
    method: 'get',
    data: data
  })
}

// 查询借支申请详细
export function getFor(borrowing) {
  return request({
    url: '/system/for/' + borrowing,
    method: 'get'
  })
}

// 新增借支申请
export function addFor(data) {
  return request({
    url: '/system/for',
    method: 'post',
    data: data
  })
}

// 修改借支申请
export function updateFor(data) {
  return request({
    url: '/system/for',
    method: 'put',
    data: data
  })
}

// 删除借支申请
export function delFor(borrowing) {
  return request({
    url: '/system/for/' + borrowing,
    method: 'delete'
  })
}

// 导出借支申请
export function exportFor(query) {
  return request({
    url: '/system/for/export',
    method: 'get',
    params: query
  })
}
