import request from '@/utils/request'

// 查询借贷列表
export function listCredit(query) {
  return request({
    url: '/debit/credit/list',
    method: 'get',
    params: query
  })
}

//根据角色查询借贷列表
export function selectDebitListByRoles(data) {
  return request({
    url: '/debit/credit/selectDebitListByRoles',
    method: 'post',
    data: data
  })
}

// 查询借贷详细
export function getCredit(debitId) {
  return request({
    url: '/debit/credit/' + debitId,
    method: 'get'
  })
}

// 新增借贷
export function addCredit(data) {
  return request({
    url: '/debit/credit',
    method: 'post',
    data: data
  })
}

// 修改借贷
export function updateCredit(data) {
  return request({
    url: '/debit/credit',
    method: 'put',
    data: data
  })
}

// 删除借贷
export function delCredit(debitId) {
  return request({
    url: '/debit/credit/' + debitId,
    method: 'delete'
  })
}

// 导出借贷
export function exportCredit(query) {
  return request({
    url: '/debit/credit/export',
    method: 'get',
    params: query
  })
}

//结算
export function settlementDebitCredit(data) {
  return request({
    url: '/debit/credit/settlementDebitCredit',
    method: 'post',
    data: data
  })
}

//还款
export function repayDebitCredit(data) {
  return request({
    url: '/debit/credit/repayDebitCredit',
    method: 'post',
    data: data
  })
}
