import request from '@/utils/request'

// 查询资金操作列表
export function listOperate(query) {
  return request({
    url: '/system/operate/list',
    method: 'get',
    params: query
  })
}

// 查询资金操作详细
export function getOperate(operateId) {
  return request({
    url: '/system/operate/' + operateId,
    method: 'get'
  })
}

// 新增资金操作
export function addOperate(data) {
  return request({
    url: '/system/operate',
    method: 'post',
    data: data
  })
}

// 修改资金操作
export function updateOperate(data) {
  return request({
    url: '/system/operate',
    method: 'put',
    data: data
  })
}

// 删除资金操作
export function delOperate(operateId) {
  return request({
    url: '/system/operate/' + operateId,
    method: 'delete'
  })
}

// 导出资金操作
export function exportOperate(query) {
  return request({
    url: '/system/operate/export',
    method: 'get',
    params: query
  })
}